define([
    'jquery',
    'underscore',
    'Vent',
    'User',
    'connectionModule',
    './modules/login/LoginUtils',
    './models/resources-collection',
    'json!resourceDirectoryJson',
    'modules/right-of-access/right-of-access_module',
],
function ($, _, vent, User, connectionModule, LoginUtils, Resources, resourceDirectory, roaModule) {

    // Global should not have any dependencies
    var utilities = {};
    var resources = new Resources(resourceDirectory, {parse: true});

    var appName = window.location.pathname.replace(/\/$/, '');
    appName = appName.replace(/^\//, '');

    var loginUtils = new LoginUtils({
        appName: appName,
        authorizeUrl: resources.get('login').get('href'),
        clientRedirectUri: '/' + appName + '/',
    });

    utilities.authorize = loginUtils.authorize;

    utilities.internetConnectionCheck = function () {
        var registerInternetDisconnectHandler = function () {
            window.addEventListener('offline', function () {
                vent.trigger('show:connection:error');
            });
            window.addEventListener('online', function () {
                vent.trigger('close:connection:error');
            });
        };
        registerInternetDisconnectHandler();
    };

    utilities.globalInit = function () {
        'use strict';

        $('body').on('pageshow', function (event, ui) {
            var prevPage = $(ui.prevPage);
            if (prevPage.hasClass('ui-dialog')) {
                prevPage.remove();
            }
        });
    };

    utilities.cleanUpSession = function () {
        sessionStorage.clear();
        $.ajaxPrefilter(function (options, originalOptions, jqXHR) {
            jqXHR.setRequestHeader('Authorization', '');
        });
    };

    var removeNewLines = function (string) {
        string = typeof string === 'string' ? string : '';
        string.replace(/\r?\n|\r/g, ' ');
        return string;
    };

    utilities.registerOauthHandler = function () {
        $(document).ajaxError(function (e, jqxhr, settings, exception) {
            if (jqxhr.status === 0 || jqxhr.status === 200) {

            }
            else if (jqxhr.status === 400) {
                if (_.isUndefined(jqxhr.responseJSON) || _.isUndefined(jqxhr.responseJSON.errors)) {
                    vent.trigger('show:server:error', null, null, 'custom',
                        removeNewLines(jqxhr.responseText), 'Error');
                }
            }
            else if (jqxhr.status === 204) {
                $.mobile.loading('hide');
                $('.ui-loader').removeAttr('style');
                $('#dialog-screen').addClass('hidden');

            }
            else if (jqxhr.status === 403) {
                if (!User.hasAcceptedROA()) {
                    roaModule.navigateToRoa();
                }
            }
            else if (jqxhr.status === 401) {
                if (jqxhr.responseText.indexOf('invalid_token') > 0) {
                    utilities.cleanUpSession();
                    vent.trigger('show:session:expired');
                }
            }
            else if (jqxhr.status === 302) {
                utilities.loginRedirect();
            }
            else if (!navigator.onLine) {
                vent.trigger('show:connection:error');
            }
            else {
                vent.trigger('show:server:error', jqxhr, settings);
            }
        });

        $.ajaxSetup({cache: false});

    };
    utilities.registerOauthHandler();

    utilities.loginRedirect = function () {
        utilities.authorize();
    };

    utilities.browserAllowed = function () {
        if (!Modernizr.audio && navigator.userAgent.indexOf('PhantomJS') < 0) {
            $('body').css({
                'background-color': 'transparent',
                'background-image': 'url("../app/images/bg_app_main.jpg")',
                'background-position': 'center center',
                'background-size': '100%',
            });
            alert('Your browser does not support this application. Please upgrade your browser or device.\n\n');
            window.location = '../newbrowser.html';
        }
    };

    utilities.eventAggregator = _.extend({}, Backbone.Events);
    utilities.eventAggregator.on('logout', function () {
        utilities.cleanUpSession();
    });

    return {
        getUtilities: function () {
            return utilities;
        },
    };
}
);
